//$**************************************************************
//$             Copyright (C) 2011 by L-1 Identity Solutions
//$  Name:        $Workfile: tpapi.h $
//$  Author:      $Author: Jmacdonald $
//$
//$  Description: TouchPrint API Definition File
//
#ifdef WIN32
   #define STDCALL __stdcall
   #ifdef TPAPI_EXPORTS
      #define TP_API __declspec(dllexport)
   #else
      #define TP_API __declspec(dllimport)
   #endif
#else
   #define MAX_PATH 260
   #define TCHAR char
   #define TP_API extern "C"
   #define STDCALL
#endif

typedef unsigned char   U8;
typedef unsigned short  U16;
#ifndef U32
   typedef unsigned int U32;
#endif
#ifndef S32
   typedef signed int   S32;
#endif

//-------------------------------------------------
//                 Error Codes
//-------------------------------------------------
#define TPAPI_NOERROR              0
#define TPAPI_ERR                  8000

#define TPAPI_UNKNOWN              (TPAPI_ERR + 0)
#define TPAPI_UNINITIALIZED        (TPAPI_ERR + 1)
#define TPAPI_OUTOFRESOURCES       (TPAPI_ERR + 2)
#define TPAPI_DEVICEUNAVAILABLE    (TPAPI_ERR + 3)
#define TPAPI_TOOMANYDEVICES       (TPAPI_ERR + 4)
#define TPAPI_TIMEOUT              (TPAPI_ERR + 5)
#define TPAPI_PARAMETEROUTOFRANGE  (TPAPI_ERR + 6)
#define TPAPI_INVALIDSTATE         (TPAPI_ERR + 7)
#define TPAPI_ACCESSVIOLATION      (TPAPI_ERR + 8)
#define TPAPI_BADRESPONSE          (TPAPI_ERR + 9)
#define TPAPI_BADFILE              (TPAPI_ERR + 10)
#define TPAPI_DFC_TOOMANYFINGERS   (TPAPI_ERR + 11)
#define TPAPI_DFC_NONPERMISSABLE_FINGER_COMBINATION (TPAPI_ERR + 12)
#define TPAPI_MAXERR               (TPAPI_ERR + 12)

#define LOGLEVEL0                  0
#define LOGLEVEL1                  1

#define MOD_TPAPI                  "TPAPI  "
#define MOD_SALI                   "SALI   "
#define MOD_IDXTIFF                "IDXTIFF"
#define MOD_PTHREAD                "PTHREAD"
#define MOD_OS                     "OS     "

//-------------------------------------------------
//            Maximum Hand Sizes
//-------------------------------------------------
enum eHandSz
{
    TP_HAND_8_INCH               = 800,
    TP_HAND_10_INCH              = 1000
};

//-------------------------------------------------
//            Scanner Bulk Data Types
//-------------------------------------------------
enum eScnDataType
{
    SCN_DTYPE_DSP                = 20,
    SCN_DTYPE_SET_PARM           = 90
};

//-------------------------------------------------
//                Image Types
//-------------------------------------------------
enum eCaptureType
{
   CTYPE_ROLL         = 0x00,
   CTYPE_SLAP_ONE     = 0x01,
   CTYPE_SLAP_FOUR    = 0x02,
   CTYPE_HAND         = 0x03,
   CTYPE_SLAP_LFOUR   = 0x04,
   CTYPE_SLAP_RFOUR   = 0x05,
   CTYPE_SLAP_THUMBS  = 0x06,

   CTYPE_SLAP_LTHUMB  = 0x07,
   CTYPE_SLAP_RTHUMB  = 0x08,

   CTYPE_ROLL_LTHUMB  = 0x09,
   CTYPE_ROLL_LINDEX  = 0x0A,
   CTYPE_ROLL_LMIDDLE = 0x0B,
   CTYPE_ROLL_LRING   = 0x0C,
   CTYPE_ROLL_LLITTLE = 0x0D,
   CTYPE_ROLL_RTHUMB  = 0x0E,
   CTYPE_ROLL_RINDEX  = 0x0F,
   CTYPE_ROLL_RMIDDLE = 0x10,
   CTYPE_ROLL_RRING   = 0x11,
   CTYPE_ROLL_RLITTLE = 0x12,

   CTYPE_SLAP_PALM    = 0x13,
   CTYPE_SLAP_LPALM   = 0x13,
   CTYPE_SLAP_RPALM   = 0x14
};

//-------------------------------------------------
//                DFC Finger Bits
//-------------------------------------------------
#define BIT_RTHUMB      0x0001
#define BIT_RINDEX      0x0002
#define BIT_RMIDDLE     0x0004
#define BIT_RRING       0x0008
#define BIT_RLITTLE     0x0010
#define BIT_LTHUMB      0x0020
#define BIT_LINDEX      0x0040
#define BIT_LMIDDLE     0x0080
#define BIT_LRING       0x0100
#define BIT_LLITTLE     0x0200

//-----------------------------------------------
// Video Mode - CSTATE_PREVIEW TP_ImgCallbk imgBuf info
//-----------------------------------------------
#define UNBANDED                   0     // Full image - imgHght indicates # of lines returned
#define BANDED_LINES               4     // Partial image - This label defines the # lines
                                         //   returned. Ysize indicates vertical position
                                         //   of returned buffer in the preview image.
//-------------------------------------------------
//                 Capture Modes
//-------------------------------------------------
typedef enum
{
   CMODE_PREVIEW_INFO            = 0x00000400,     // generate info on preview
   CMODE_RTQA                    = 0x00002000,     // enable real-time quality analyis
   CMODE_REVIEW                  = 0x00008000,     // require operator review
   CMODE_AUTO_CAP                = 0x00800000,     // device will determine when to capture print
   CMODE_AUTO_CAP_WITH_PREVIEW   = 0x04000000,     // device Auto-capture with roll preview
   CMODE_DISABLE_KEYS            = 0x08000000,     // Disable the scan/save keys
   CMODE_DISABLE_BEEP            = 0x80000000      // Disable device-controlled beeps
} eCaptureMode;          

//-------------------------------------------------
//                 Capture States
//-------------------------------------------------
typedef enum
{
    CSTATE_IDLE        = 0x00000000,
    CSTATE_PREVIEW     = 0x00000001,     // preview image is available
    CSTATE_STARTED     = 0x00000002,     // SCAN button pressed, capture begun
    CSTATE_ABORTED     = 0x00000003,     // SAVE button pressed during Preview
    CSTATE_CAPTURED    = 0x00000004,     // image captured, decorated image may be available
    CSTATE_FINISHED    = 0x00000005,     // capture complete, finished image available
    CSTATE_REJECTED    = 0x00000006,     // SCAN button pressed during Review
    CSTATE_CANCELED    = 0x00000007,     // capture stopped by host
    CSTATE_FAILED      = 0x00000008,     // capture failed due to hardware or system errors
    CSTATE_TOOFAST     = 0x00000009      // handprint rolled too fast - capture refused
} CaptureState;

struct s_imgSize
{
   unsigned int x;
   unsigned int y;
};

//-------------------------------------------------
//            RTQA Image Information
//-------------------------------------------------
struct s_imgQA
{
    unsigned short cover_factor;
    unsigned short roll_time;
    unsigned short contact_area;
    unsigned short good_area;
    unsigned short dark_area;
    unsigned short light_area;
    unsigned short smear_area;
};

//-------------------------------------------------
//            Device UI Information
//-------------------------------------------------
enum eUIType
{
   UI_NONE					= 0x00000001,
   UI_4_4_2_TRI_LED
};

enum eLEDState
{
   UI_LED_OFF					= 0x00000000,
   UI_LED_GREEN,
   UI_LED_RED,
   UI_LED_YELLOW
};

struct s_442TriLED		// UIType is UI_4_4_2_TRI_LED
{
    enum eLEDState left_four_progress;    // Left four finger progress LED
    enum eLEDState right_four_progress;   // etc.
    enum eLEDState thumb_progress;
    enum eLEDState left_index;
    enum eLEDState left_middle;
    enum eLEDState left_ring;
    enum eLEDState left_little;
    enum eLEDState right_index;
    enum eLEDState right_middle;
    enum eLEDState right_ring;
    enum eLEDState right_little;
    enum eLEDState left_thumb;
    enum eLEDState right_thumb;
};

enum eCapControl
{
   CC_CANCEL_CAPTURE			= 0x0000000,
   CC_CAPTURE_IMAGE,
   CC_FINISH_IMAGE
};

//-------------------------------------------------
//             Switch Information
//-------------------------------------------------
#define QRYSW_CANCEL         -1          // Cancel previous query (i.e. wait)
#define QRYSW_NOCLEAR         0          // Prompt and return when a switch 
                                         //   closure is detected
#define QRYSW_CLEAR           1          // Clear prior switch states, prompt,
                                         //   and wait for a switch closure
#define QRYSW_NOWAIT          2          // Return switch states immediately
#define QRYSW_BEEP_ONLY       3

#define SW_BSCAN_LATCHED      0x01       // Scan button pressed since last query
#define SW_BSAVE_LATCHED      0x02       // Save button pressed since last query
#define SW_FSAVE_LATCHED      0x04       // Save foot-switch pressed since last query
#define SW_FSCAN_LATCHED      0x08       // Scan foot-switch pressed since last query
#define SW_NOT_SCAN_NOW       0x10       // Scan button currently NOT pressed
#define SW_NOT_BSAVE_NOW      0x20       // Save button currently NOT pressed
#define SW_NOT_FSAVE_NOW      0x40       // Save foot-switch currently NOT pressed
#define SW_NOT_FSCAN_NOW      0x80       // Scan foot-switch currently NOT pressed
#define SW_SWITCH_TIMEOUT     0xF0       // WaitMsec timeout expired

//-------------------------------------------------
//             Device Information
//-------------------------------------------------
struct s_devInfo                        // All arrays NULL-terminated
{
   char assy_make[8];                   // Assembly Make (e.g. IDX) 
   char assy_model[16];                 // Assembly Model (e.g. TP-4100) 
   char assy_sn[16];                    // Assembly Serial Number (e.g. 123456) 
   char sw_version[12];                 // Embedded Firmware Application Version 
};

struct s_fngrThlds
{
   unsigned long minimum;
   unsigned long okay;
   unsigned long good;
};

#define TPAPI_MAX_DEVICES     2

// TP-LSMULTI-supported link library types
#define TPAPI_LNK_USB         0
#define TPAPI_LNK_1394_OHCI   1
#define TPAPI_LNK_1394_UB     2

struct s_tpDevList
{
   TCHAR devName[255];
   char assy_model[16];                // Assembly Model (e.g. TP-4100) 
   char assy_sn[16];                   // Assembly Serial Number (e.g. 123456) 
   U32 libType;                        // Link library type
};

//-------------------------------------------------
//          CMODE_PREVIEW_INFO
//-------------------------------------------------
/* Type of slap detected */
enum eSlapDetect
{
   SLAP_DETECT_NOT_IMPLEMENTED  = -1,
   SLAP_DETECT_UNKNOWN          =  0,
   SLAP_DETECT_LEFT_HAND        =  1,
   SLAP_DETECT_RIGHT_HAND       =  2,
   SLAP_DETECT_TWO_THUMBS       =  3
};

// Measurement of the contact using density
enum eFngrDensity
{
   FNGR_NO_CONTACT              =  0,
   FNGR_POOR_CONTACT,
   FNGR_GOOD_CONTACT,
   FNGR_GREAT_CONTACT
};

// App RTQA numbers
struct s_FngrRtqa
{
  unsigned long contactPct;  // percent of the platen area with contact
  unsigned long goodPct;     // percent of the contact area with good cells
  unsigned long darkPct;     // percent of the contact area with dark cells
  unsigned long lightPct;    // percent of the contact area with light cells
  unsigned long smearPct;    // percent of the contact area with smeared cells
};

// All of the information for a single finger
struct s_FngrInfo
{
   struct s_FngrRtqa  fngrRtqa;
   enum eFngrDensity  fngrContact;
};

struct s_PreviewInfo
{
   struct s_FngrInfo fngrInfo[4];
   enum eSlapDetect slapDetect;
};

//-------------------------------------------------
//              Function Prototypes
//-------------------------------------------------
TP_API long STDCALL TP_InitializeAPI(void);
TP_API long STDCALL TP_TerminateAPI(void);
TP_API long STDCALL TP_GetDeviceList(U32 *, struct s_tpDevList *);
TP_API long STDCALL TP_OpenDevice(TCHAR *, U32, U32*);
TP_API long STDCALL TP_CloseDevice(U32);
TP_API bool STDCALL TP_DeviceConnected(U32);
TP_API long STDCALL TP_GetDeviceInfo(U32, struct s_devInfo *);
TP_API long STDCALL TP_ResetDevice(U32);
TP_API long STDCALL TP_SetResolution(U32, enum eCaptureType, U32);
TP_API long STDCALL TP_GetResolution(U32, enum eCaptureType, U32*);
TP_API long STDCALL TP_GetMaxVideoSize(U32, enum eCaptureType, U16*, U16*);
TP_API long STDCALL TP_GetFinishedImageSize(U32, enum eCaptureType, U32, struct s_imgSize*);
TP_API long STDCALL TP_SetDeviceUI(U32, enum eUIType, void *);
TP_API long STDCALL TP_GetDeviceUI(U32, enum eUIType, void *);
TP_API long STDCALL TP_IsDeviceUISupported(U32, enum eUIType, bool*);
TP_API long STDCALL TP_IsCaptureTypeSupported(U32, enum eCaptureType, bool*);
TP_API long STDCALL TP_IsAutoCaptureSupported(U32, enum eCaptureType, bool*);
TP_API long STDCALL TP_IsCalibrationSupported(U32, enum eCaptureType, bool*);
TP_API long STDCALL TP_IsCalibrated(U32, enum eCaptureType, bool*);
TP_API long STDCALL TP_CalibrateScanner(U32, enum eCaptureType);
TP_API long STDCALL TP_SendBulkData(U32, enum eScnDataType, U8*, U32);
TP_API long STDCALL TP_GetSlapFngrThresholds(U32, struct s_fngrThlds *);
TP_API long STDCALL TP_SetSlapFngrThresholds(U32, struct s_fngrThlds *);
TP_API long STDCALL TP_GetSlapFngrRTQA(U32, U32 thrlds[10]);
TP_API long STDCALL TP_SetSlapFngrRTQA(U32, U32 thrlds[10]);
TP_API long STDCALL TP_GetSlapAutoCapTimeouts(U32, U32*, U32*, U32*);
TP_API long STDCALL TP_SetSlapAutoCapTimeouts(U32, U32, U32, U32);
TP_API long STDCALL TP_GetSlapAutoCapPrimaryFngrs(U32, U32*);
TP_API long STDCALL TP_SetSlapAutoCapPrimaryFngrs(U32, U32);
TP_API long STDCALL TP_GetMaxHandSize(U32, enum eHandSz *);
TP_API long STDCALL TP_SetMaxHandSize(U32, enum eHandSz);
TP_API long STDCALL TP_StartPreview(U32, enum eCaptureType, U32, U16, U16, 
         long (STDCALL *TP_ImgCallbk)(U32, U32, U8*, U16, U16, void *), void *);
TP_API long STDCALL TP_StartPreviewDFC(U32, enum eCaptureType, U32, U32, struct s_imgSize*,
      	long (STDCALL *TP_ImgCallbk)(U32, U32, U8*, U16, U16, void *), void *);
TP_API long STDCALL TP_CaptureControl(U32, enum eCapControl);
TP_API long STDCALL TP_GetImageQA(U32, struct s_imgQA *);
TP_API long	STDCALL TP_QuerySwitches(U32, S32, U32, U32, U32 Freq[3], U32 Time[3], U16*);

//-------------------------------------------------
//         Deprecated Function Prototypes
//-------------------------------------------------
TP_API long STDCALL StartPreview(enum eCaptureType capType, 
			unsigned long capMode, unsigned short videoW, unsigned short videoH,
         long (STDCALL *ImgCallbk)(int capState, 
			  unsigned char *ImageBuf, unsigned short Xsize, 
			  unsigned short Ysize));
TP_API long STDCALL StopPreview(void);
TP_API long STDCALL CaptureControl(enum eCapControl CapControl);
TP_API long STDCALL GetImageQA(struct s_imgQA *pParams);
TP_API long	STDCALL QuerySwitches(long Mode, 
         unsigned long WaitMsec, unsigned long Prompt, 
         unsigned long Freq[3], unsigned long Time[3], 
         unsigned short *SwitchState);
TP_API long STDCALL SetResolution(enum eCaptureType capType, unsigned int dpi);
TP_API long STDCALL GetResolution(enum eCaptureType capType, unsigned int *dpi);
TP_API long STDCALL GetMaxVideoSize(enum eCaptureType capType,
          unsigned short *videoW,unsigned short *videoH);
TP_API long STDCALL GetFinishedImageSize(enum eCaptureType capType, 
         unsigned int dpi,struct s_imgSize *imgSize);
TP_API long STDCALL SetDeviceUI(enum eUIType UIType , void *pUI);
TP_API long STDCALL GetDeviceUI(enum eUIType UIType , void *pUI);
TP_API long STDCALL IsDeviceUISupported(enum eUIType UIType, bool *result);
TP_API long STDCALL IsCaptureTypeSupported(enum eCaptureType capType, bool *result);
TP_API long STDCALL IsAutoCaptureSupported(enum eCaptureType capType, bool *result);
TP_API long STDCALL CalibrateScanner(enum eCaptureType capType);
TP_API long STDCALL IsCalibrated(enum eCaptureType capType, bool *result);
TP_API long STDCALL IsCalibrationSupported(enum eCaptureType capType, bool *result);
TP_API long STDCALL SendBulkData(enum eScnDataType dType, 
			unsigned char *buf, unsigned int len);
TP_API long STDCALL GetSlapFngrThresholds(struct s_fngrThlds *fngrThrld);
TP_API long STDCALL SetSlapFngrThresholds(struct s_fngrThlds *fngrThrld);
TP_API long STDCALL GetSlapAutoCapTimeouts(unsigned long *capDelay, 
         unsigned long *capTmOut, unsigned long *altCapTmOut);
TP_API long STDCALL SetSlapAutoCapTimeouts(unsigned long capDelay, 
         unsigned long capTmOut, unsigned long altCapTmOut);
TP_API long STDCALL GetSlapAutoCapPrimaryFngrs(unsigned long *numFngrs);
TP_API long STDCALL SetSlapAutoCapPrimaryFngrs(unsigned long numFngrs);
TP_API long STDCALL GetMaxHandSize(enum eHandSz *hndSz);
TP_API long STDCALL SetMaxHandSize(enum eHandSz hndSz);
TP_API long STDCALL GetDeviceInfo(struct s_devInfo *pInfo);
TP_API bool STDCALL DeviceConnected(void);
TP_API long STDCALL ResetDevice(void);
TP_API long STDCALL TerminateAPI(void);
TP_API long STDCALL InitializeAPI(void);

